
IF NOT EXISTS(
	SELECT 
		1
	FROM 
		 sys.tables 
	WHERE 
		NAME = 'EST_PROD_TBL_COMIS_EST_PROD' )
BEGIN

SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[EST_PROD_TBL_COMIS_EST_PROD](
	[CD_EMP] [INT] NOT NULL,
	[CD_TBL_COMIS] [INT] NOT NULL,
	[CD_PROD] [INT] NOT NULL,
	[PERC_COMIS] [MONEY] NOT NULL,
 CONSTRAINT [PK_EST_PROD_TBL_COMIS_EST_PROD] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_TBL_COMIS] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_COMIS_EST_PROD_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])
ON UPDATE CASCADE

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_EST_PROD] CHECK CONSTRAINT [FK_EST_PROD_TBL_COMIS_EST_PROD_EST_PROD]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_COMIS_EST_PROD_EST_PROD_TBL_DESC] FOREIGN KEY([CD_EMP], [CD_TBL_COMIS])
REFERENCES [dbo].[EST_PROD_TBL_COMIS] ([CD_EMP], [CD_TBL_COMIS])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_EST_PROD] CHECK CONSTRAINT [FK_EST_PROD_TBL_COMIS_EST_PROD_EST_PROD_TBL_DESC]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_EST_PROD] ADD  CONSTRAINT [DF_EST_PROD_TBL_COMIS_EST_PROD_PERC_COMIS]  DEFAULT ((0)) FOR [PERC_COMIS]

END

